﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP.CRS.BO;
using VIRP.CRS.BLL;
using VIRP.EFR.BO;
using VIRP.EFR.BLL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class Surveys : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            pnlModalPanel.Visible = false;
            GridViewEFRSurveys.Visible = true;

            if (!IsPostBack)
            {
                int statusId = 0;

                if (int.TryParse(Request.QueryString["statusId"], out statusId))
                {
                    // Store in session
                    Session["Surveys.statusId"] = SessionItemFactory.Create(statusId.ToString());
                    Session["Surveys.sortColumn"] = SessionItemFactory.Create("CaseId");
                    Session["Surveys.sortOrder"] = SessionItemFactory.Create("Descending");

                    //check if it's in-process or completed questionnaire(now in new status)
                    if (statusId == 6)
                    {
                        GridViewEFRSurveys.Columns[10].Visible = false;
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Questionnaires/Forms > New";
                    }
                    else if (statusId == 2)
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Questionnaires/Forms > Completed";
                    }
                    else if (statusId == 1)
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Questionnaires/Forms > In Process";
                    }
                    else 
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "Questionnaires/Forms";
                    }

                    // Bind our data
                    try
                    {
                        GridViewEFRSurveys.DataSource = GetSurveys();  // sdr;
                        GridViewEFRSurveys.DataBind();
                    }
                    catch
                    { }
                }

                HiddenFieldClearFlag.Value = "0";
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRSurveys.ClientID + "');", true);
        }

        protected void Surveys_RowDataBound(object sender, GridViewRowEventArgs e)
        {
        }

        public void Surveys_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRSurveys.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRSurveys.SelectedValue);

                var userId = HttpContext.Current.User.Identity.Name;
                var registryId = UserSession.CurrentRegistryId;

                try
                {
                    WKF_CASE_ACTIVITY wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, id);
                    WKF_CASE wc = VIRP.CRS.BLL.WKF_CASEManager.GetItem(userId, registryId, wca.WKF_CASE_ID);
                    STD_WKFCASETYPE swct = STD_WKFCASETYPEManager.GetItem(userId, registryId, wc.STD_WKFCASETYPE_ID);

                    string slUrl = "SurveyLink.aspx?activityId=" + id.ToString();
                    string s2009Url = "Survey2009.aspx?activityId=" + id.ToString();

                    if (swct.ID == 12) //wca.STD_WKFACTIVITYTYPE_ID == 3) // Biomonitoring
                    {
                        Response.Redirect(slUrl);
                    }
                    else if (swct.ID == 13) //wca.STD_WKFACTIVITYTYPE_ID == 4) // Fragment
                    {
                        Response.Redirect(s2009Url);
                    }
                    else
                    {
                        ServiceInterfaceManager.LogError("Invalid test.STD_WKFACTIVITYTYPE_ID: " + wca.STD_WKFACTIVITYTYPE_ID.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);

                        Response.Redirect(slUrl);
                    }
                }
                catch (Exception ex)
                {
                    ServiceInterfaceManager.LogError(ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                }
            }

            if (e.CommandName == "ViewReport")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRSurveys.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRSurveys.SelectedValue);

                string url = "~/Custom/EFR/Questionnaires/QuestionnaireSummary.aspx?activityId=" + id.ToString();
                Response.Redirect(url);

                //string url = HttpContext.Current.Request.Url.AbsoluteUri.Substring(0, HttpContext.Current.Request.Url.AbsoluteUri.LastIndexOf('/'));
                //url += "/QuestionnaireSummary.aspx?activityId=" + id.ToString();

                //System.Diagnostics.Process.Start(url);
            }
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxSearchCriteria.Text = String.Empty;
            HiddenFieldClearFlag.Value = "1";

            GridViewEFRSurveys.DataSource = GetSurveys();
            GridViewEFRSurveys.DataBind();
        }

        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridViewEFRSurveys.PageIndex = 0;
            HiddenFieldClearFlag.Value = "0";

            GridViewEFRSurveys.DataSource = GetSurveys();
            GridViewEFRSurveys.DataBind();
        }

        public DataTable GetSurveys()
        {
            DataTable dt = new DataTable();
            string lastName = TextBoxSearchCriteria.Text;
            int statusId = 0;

            try
            {
                statusId = Convert.ToInt32(Helpers.SessionItemValueGet(Session["Surveys.statusId"]));
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Error converting statusId to int: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
            }

            try
            {
                var sortColumn = Helpers.SessionItemValueGet(Session["Surveys.sortColumn"]);
                var sortOrder = Helpers.SessionItemValueGet(Session["Surveys.sortOrder"]);

                var username = HttpContext.Current.User.Identity.Name;

                List<QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_LIST> lSurveys =
                    QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetSurveyItems(username, CurrentRegistryId, statusId, 2, lastName, sortColumn, sortOrder);

                dt.Columns.Add("CaseId");
                dt.Columns.Add("SurveyId");
                dt.Columns.Add("PatientName");
                dt.Columns.Add("StationNumber");
                dt.Columns.Add("Institution");
                dt.Columns.Add("ReceivedDate");
                dt.Columns.Add("Version");
                dt.Columns.Add("SurveyStatus");
                dt.Columns.Add("SurveyType");

                foreach (var item in lSurveys)
                {
                    var row = dt.NewRow();

                    row["CaseId"] = item.CASEID;
                    row["SurveyId"] = item.SURVEYID;
                    row["PatientName"] = item.PATIENTNAME;
                    row["StationNumber"] = item.STATIONNUMBER;
                    row["Institution"] = item.INSTITUTION;
                    row["ReceivedDate"] = item.RECEIVEDDATE;
                    row["Version"] = item.VERSION;
                    row["SurveyStatus"] = item.SURVEYSTATUS;
                    row["SurveyType"] = item.SURVEYTYPE;

                    dt.Rows.Add(row);
                }
            }
            catch (Exception ex)
            {
                pnlModalPanel.Visible = true;
                GridViewEFRSurveys.Visible = false;
                LabelReport.Text = "Error retrieving questionnaires due to an application error. <br/>" + ex.Message;
               
                ServiceInterfaceManager.LogError("Error retrieving surveys: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
            }

            return dt;
        }
        protected void Surveys_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
        }
        protected void Surveys_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridViewEFRSurveys.DataSource = GetSurveys();
            GridViewEFRSurveys.PageIndex = e.NewPageIndex;
            GridViewEFRSurveys.DataBind();
        }
        protected void Surveys_Sorting(object sender, GridViewSortEventArgs e)
        {
            // Sort order is always Ascending ... deal with this
            var sortOrder = Helpers.SessionItemValueGet(Session["Surveys.sortOrder"]);
            var sortColumn = Helpers.SessionItemValueGet(Session["Surveys.sortColumn"]);

            if (sortColumn == e.SortExpression && sortOrder == e.SortDirection.ToString())
            {
                if (sortOrder == "Ascending")
                    Session["Surveys.sortOrder"] = SessionItemFactory.Create("Descending");
                else
                    Session["Surveys.sortOrder"] = SessionItemFactory.Create("Ascending");
            }
            else
            {
                Session["Surveys.sortOrder"] = SessionItemFactory.Create(e.SortDirection.ToString());
                Session["Surveys.sortColumn"] = SessionItemFactory.Create(e.SortExpression.ToString());
            }

            GridViewEFRSurveys.DataSource = GetSurveys();
            GridViewEFRSurveys.PageIndex = 0;
            GridViewEFRSurveys.DataBind();
        }
    }
}